/*
 * Decompiled with CFR 0.152.
 */
package br.com.hagane.install.validator;

import br.com.hagane.scl.secutiry.SerialKeyManager;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.DataValidator;

public class SerialKeyValidator
implements DataValidator {
    private String mensagem;

    @Override
    public boolean getDefaultAnswer() {
        return false;
    }

    @Override
    public String getErrorMessageId() {
        if (this.mensagem == null) {
            this.mensagem = "serialKey.genericError";
        }
        return this.mensagem;
    }

    @Override
    public String getWarningMessageId() {
        return "WARNING";
    }

    @Override
    public DataValidator.Status validateData(AutomatedInstallData automatedInstallData) {
        try {
            String serialKey = automatedInstallData.getVariable("txt.serialKey").replaceAll("\\.", "-");
            if (serialKey != null && SerialKeyManager.validarSerialKey(serialKey)) {
                automatedInstallData.setAttribute("serialKey", serialKey);
                return DataValidator.Status.OK;
            }
            this.mensagem = "serialKey.validationError";
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return DataValidator.Status.ERROR;
    }
}

